/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.client.screens.widgets.MultiStateSnapshotWidget;
import mod.chiselsandbits.container.ModificationTableContainer;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipe;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

public class ModificationTableScreen
extends class_465<ModificationTableContainer> {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("chiselsandbits", "textures/gui/container/modification_table.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;
    private MultiStateSnapshotWidget snapshotWidget;
    private int lastRenderedSelectedRecipeIndex = -1;

    public ModificationTableScreen(ModificationTableContainer containerIn, class_1661 playerInv, class_2561 titleIn) {
        super((class_1703)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.field_25268;
        this.field_2779 = 197;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.snapshotWidget = (MultiStateSnapshotWidget)this.method_37063(new MultiStateSnapshotWidget(this.field_2776 + 51, this.field_2800 + 71, 66, 28, (class_2561)new class_2588("chiselsandbits.screen.widgets.multistate.preview")));
    }

    public void method_25394(@NotNull class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.method_2380(matrixStack, mouseX, mouseY);
    }

    protected void method_2389(@NotNull class_4587 matrixStack, float partialTicks, int x, int y) {
        this.method_25420(matrixStack);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        int left = this.field_2776;
        int top = this.field_2800;
        this.method_25302(matrixStack, left, top, 0, 0, this.field_2792, this.field_2779);
        int sliderOffset = (int)(41.0f * this.sliderProgress);
        this.method_25302(matrixStack, left + 119, top + 15 + sliderOffset, this.field_2792 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int recipesLeft = this.field_2776 + 52;
        int recipesTop = this.field_2800 + 14;
        int recipeIndexOffsetMax = this.recipeIndexOffset + 12;
        this.renderButtons(matrixStack, x, y, recipesLeft, recipesTop, recipeIndexOffsetMax);
        this.drawRecipesItems(recipesLeft, recipesTop, recipeIndexOffsetMax);
        if (this.lastRenderedSelectedRecipeIndex != ((ModificationTableContainer)this.field_2797).getSelectedRecipe() && this.hasItemsInInputSlot) {
            this.lastRenderedSelectedRecipeIndex = ((ModificationTableContainer)this.field_2797).getSelectedRecipe();
            IMultiStateSnapshot snapshot = ((ModificationTableContainer)this.field_2797).getRecipeList().get(this.lastRenderedSelectedRecipeIndex).getAppliedSnapshot(((ModificationTableContainer)this.field_2797).inputInventory);
            this.snapshotWidget.setSnapshot(snapshot);
        }
    }

    protected void method_2380(@NotNull class_4587 matrixStack, int x, int y) {
        super.method_2380(matrixStack, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.recipeIndexOffset + 12;
            List<ModificationTableRecipe> list = ((ModificationTableContainer)this.field_2797).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((ModificationTableContainer)this.field_2797).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.method_25424(matrixStack, list.get(l).getDisplayName(), x, y);
            }
        }
    }

    private void renderButtons(class_4587 matrixStack, int x, int y, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.recipeIndexOffset; i < p_238853_6_ && i < ((ModificationTableContainer)this.field_2797).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.field_2779;
            if (i == ((ModificationTableContainer)this.field_2797).getSelectedRecipe()) {
                j1 += 18;
            } else if (x >= k && y >= i1 && x < k + 16 && y < i1 + 18) {
                j1 += 36;
            }
            this.method_25302(matrixStack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int recipesLeft, int recipesTop, int recipeIndexOffsetMax) {
        List<ModificationTableRecipe> list = ((ModificationTableContainer)this.field_2797).getRecipeList();
        for (int offset = this.recipeIndexOffset; offset < recipeIndexOffsetMax && offset < ((ModificationTableContainer)this.field_2797).getRecipeListSize(); ++offset) {
            int itemIndex = offset - this.recipeIndexOffset;
            int itemX = recipesLeft + itemIndex % 4 * 16;
            int rowIndex = itemIndex / 4;
            int itemY = recipesTop + rowIndex * 18 + 2;
            if (this.field_22787 == null) continue;
            this.field_22787.method_1480().method_4023(list.get(offset).getCraftingBlockResult(((ModificationTableContainer)this.field_2797).inputInventory), itemX, itemY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (this.field_22787 == null || this.field_22787.field_1724 == null || !(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((ModificationTableContainer)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, l)) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                if (this.field_22787.field_1761 != null) {
                    this.field_22787.field_1761.method_2900(((ModificationTableContainer)this.field_2797).field_7763, l);
                }
                return true;
            }
            i = this.field_2776 + 119;
            j = this.field_2800 + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = class_3532.method_15363((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        if (this.snapshotWidget.method_25405(mouseX, mouseY)) {
            return this.snapshotWidget.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.snapshotWidget.method_25405(mouseX, mouseY)) {
            return this.snapshotWidget.method_25401(mouseX, mouseY, delta);
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = class_3532.method_15363((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((ModificationTableContainer)this.field_2797).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((ModificationTableContainer)this.field_2797).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((ModificationTableContainer)this.field_2797).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
            this.snapshotWidget.setSnapshot(EmptySnapshot.INSTANCE);
            this.lastRenderedSelectedRecipeIndex = -1;
        }
    }
}

